<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller;

use app\api\lists\RechargeTemplateLists;
use app\api\logic\RechargeLogic;

/**
 * 充值控制器
 * Class RechargeController
 * @package app\api\controller
 */
class Recharge extends BaseShopController
{
    /**
     * @notes 查看充值模板列表
     * @return \think\response\Json
     */
    public function rechargeTemplateLists()
    {
        return $this->dataLists(new RechargeTemplateLists());
    }

    /**
     * @notes 充值
     * @return \think\response\Json
     */
    public function recharge()
    {
        $params = $this->request->post();
        $params['user_id'] = $this->userId;
        $params['terminal'] = $this->userInfo['terminal'];
        $result = RechargeLogic::recharge($params);
        if($result) {
            return $this->data($result);
        }
        return $this->fail(RechargeLogic::getError());
    }

    /**
     * @notes 查看充值记录列表
     * @return \think\response\Json
     */
    public function lists()
    {
        return $this->dataLists();
    }
}