<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\controller;

use app\common\enum\UserTerminalEnum;
use app\common\logic\PaymentLogic;
use app\common\service\pay\AliPayService;
use app\common\service\pay\ToutiaoPayService;
use app\common\service\pay\WeChatPayService;
use app\api\validate\PayValidate;
use think\facade\Log;
use app\common\service\pay\EPayService;

/**
 * 支付
 * Class PayController
 * @package app\api\controller
 */
class Pay extends BaseShopController
{

    public array $notNeedLogin = ['notifyMnp', 'notifyOa', 'notifyApp', 'aliNotify','epayNotify', 'toutiaoNotify'];


    /**
     * @notes 预支付
     * @return \think\response\Json
     * @throws \Exception
     */
    public function prepay()
    {
        $params = (new PayValidate())->post()->goCheck();
        
        //订单信息
        $order = PaymentLogic::getPayOrderInfo($params);
        if (false === $order) {
            return $this->fail(PaymentLogic::getError(), $params);
        }
        if($params['from'] == 'question' && !$order['user_id']){
            $order['user_id']=$this->userId;
            \app\common\model\QuestionOrder::update(['user_id'=>$this->userId],['id'=>$params['order_id']]);
        }
        // terminal=订单来源;1-微信小程序;2-微信公众号;3-手机H5;4-PC;5-苹果app;6-安卓app;
        $terminal = isset($params['terminal'])?$params['terminal']:$this->userInfo['terminal'];
        $result = PaymentLogic::pay($params['pay_way'], $params['from'], $order, $terminal);
        // dd($result);
        if (false === $result) {
            return $this->fail(PaymentLogic::getError(), $params);
        }
        return $this->success('', $result);

    }

    /**
     * @notes 小程序支付回调
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function notifyMnp()
    {
        
        // $res = $this->request->post();
        // $json_str = json_encode($res,JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        // $res = writeToFile('./ccccdddpay_res.txt', $json_str);
        // dd($res);
        return (new WeChatPayService(UserTerminalEnum::WECHAT_MMP))->notify();
    }


    /**
     * @notes 公众号支付回调
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function notifyOa()
    {
        return (new WeChatPayService(UserTerminalEnum::WECHAT_OA))->notify();
    }



    /**
     * @notes app支付回调
     */
    public function notifyApp()
    {
        return (new WeChatPayService(UserTerminalEnum::IOS))->notify();
    }


    /**
     * @notes 支付宝回调
     * @return bool
     */
    public function aliNotify()
    {
        $params = $this->request->post();
        $result = (new AliPayService())->notify($params);
        if (true === $result) {
            echo 'success';
        } else {
            echo 'fail';
        }
    }

    /**
     * @notes 支付宝回调
     * @return bool
     */
    public function epayNotify()
    {
        $params = input();
        $result = (new EPayService())->notify($params);
        if (true === $result) {
            echo 'success';
        } else {
            echo 'fail';
        }
    }
    


    /**
     * @notes  支付方式列表
     * @return \think\response\Json
     */
    public function payway()
    {
        $params = (new PayValidate())->goCheck('payway');
        $result = PaymentLogic::getPayWay($this->userId, $this->userInfo['terminal'], $params);
        if ($result === false) {
            return $this->fail(PaymentLogic::getError());
        }
        return $this->data($result);
    }

    public function payStatus()
    {
        $params = (new PayValidate())->goCheck('paystatus');
        $result = PaymentLogic::getPayStatus($params);
        if ($result === false) {
           return $this->fail(PaymentLogic::getError());
        }
        return $this->data($result);
    }


    /**
     * @notes 获取支付结果
     * @return \think\response\Json
     * @date 2022/4/6 15:23
     */
    public function payResult()
    {
        $params = (new PayValidate())->goCheck('payresult');
        $result = PaymentLogic::getPayResult($params);
        if ($result === false) {
            return $this->fail(PaymentLogic::getError());
        }
        return $this->data($result);
    }


}
