<?php

namespace app\api\controller;

use app\common\service\after_sale\AfterSaleService;
use app\api\logic\AfterSaleLogic;
use app\api\validate\AfterSaleValidate;
use think\facade\Db;
use think\Validate;

/**
 * 售后控制器
 * Class AfterSaleController
 * @package app\api\controller
 */
class AfterSale extends BaseShopController
{
    /**
     * @notes 子订单商品信息
     * @return \think\response\Json
     */
    public function orderGoodsInfo()
    {
        $params = (new AfterSaleValidate())->goCheck('orderGoodsInfo');
        $result = AfterSaleLogic::orderGoodsInfo($params);
        return $this->data($result);
    }

    /**
     * @notes 申请商品售后
     * @return \think\response\Json
     */
    public function apply()
    {
        $params = (new AfterSaleValidate())->post()->goCheck('apply');
        $params['user_id'] = $this->userId;
        $result = AfterSaleLogic::apply($params);
        if($result === false) {
            return $this->fail(AfterSaleLogic::getError());
        }
        return $this->success('申请商品售后成功', $result);

    }

    /**
     * @notes 买家取消售后
     * @return \think\response\Json
     */
    public function cancel()
    {
        $params = (new AfterSaleValidate())->post()->goCheck('cancel');
        $params['user_id'] = $this->userId;
        $result = AfterSaleLogic::cancel($params);
        if($result) {
            return $this->success('买家取消售后成功');
        }
        return $this->fail(AfterSaleLogic::getError());
    }

    /**
     * @notes 买家确认退货
     * @return \think\response\Json
     */
    public function returnGoods()
    {
        $params = (new AfterSaleValidate())->post()->goCheck('returnGoods');
        $params['user_id'] = $this->userId;
        $result = AfterSaleLogic::returnGoods($params);
        if($result) {
            return $this->success('买家确认退货');
        }
        return $this->fail(AfterSaleLogic::getError());
    }

    /**
     * @notes 查看售后列表
     * @return \think\response\Json
     */
    public function lists()
    {
        $params = (new AfterSaleValidate())->goCheck('lists');
        $params['user_id'] = $this->userId;
        $params['page_no'] = $params['page_no'] ?? 1;
        $params['page_size'] = $params['page_size'] ?? 25;
        $result = AfterSaleLogic::lists($params);
        return $this->data($result);
    }

    /**
     * @notes 查看售后详情
     * @return \think\response\Json
     */
    public function detail()
    {
        $params = (new AfterSaleValidate())->goCheck('detail');
        $result = AfterSaleLogic::detail($params);
        return $this->data($result);
    }

}