<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\settings\delivery;


use app\common\logic\BaseLogic;
use app\common\service\ConfigService;

class DeliveryWayLogic extends BaseLogic
{
    /**
     * @notes 查看配送方式配置
     * @return array|int|mixed|string|null
     */
    public function getConfig()
    {
        return [
            'express' => [
                'is_express' => ConfigService::get('delivery_type', 'is_express', 1),
                'express_name' => ConfigService::get('delivery_type', 'express_name', '快递发货'),
            ]
        ];
    }

    /**
     * @notes 设置配送方式配置
     * @param $params
     * @return bool
     */
    public function setConfig($params)
    {
        ConfigService::set('delivery_type', 'is_express', $params['is_express']);
        ConfigService::set('delivery_type', 'express_name', $params['express_name']);

        return true;
    }
}