<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\goods;


use app\common\enum\DefaultEnum;
use app\common\model\GoodsSupplier;

class GoodsSupplierLogic
{
    /**
     * @notes 添加供应商
     * @param $params
     * @return bool
     */
    public function add($params)
    {
        $goods_supplier = new GoodsSupplier;
        $goods_supplier->code = $params['code'];
        $goods_supplier->name = $params['name'];
        $goods_supplier->supplier_category_id = $params['supplier_category_id'];
        $goods_supplier->contact = $params['contact'] ?? '';
        $goods_supplier->mobile = $params['mobile'] ?? '';
        $goods_supplier->landline = $params['landline'] ?? '';
        $goods_supplier->email = $params['email'] ?? '';
        $goods_supplier->province_id = $params['province_id'] ?? '';
        $goods_supplier->city_id = $params['city_id'] ?? '';
        $goods_supplier->district_id = $params['district_id'] ?? '';
        $goods_supplier->address = $params['address'] ?? '';
        $goods_supplier->bank_account = $params['bank_account'] ?? '';
        $goods_supplier->bank = $params['bank'] ?? '';
        $goods_supplier->cardholder_name = $params['cardholder_name'] ?? '';
        $goods_supplier->tax_id = $params['tax_id'] ?? '';
        $goods_supplier->sort = (isset($params['sort']) && !empty($params['sort'])) ? $params['sort'] : DefaultEnum::SORT;
        return $goods_supplier->save();
    }

    /**
     * @notes 删除供应商
     * @param $params
     * @return bool
     */
    public function del($params)
    {
        return GoodsSupplier::destroy($params['id']);
    }

    /**
     * @notes 编辑供应商
     * @param $params
     * @return bool
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function edit($params)
    {
        $goods_supplier = GoodsSupplier::find($params['id']);
        $goods_supplier->code = $params['code'];
        $goods_supplier->name = $params['name'];
        $goods_supplier->supplier_category_id = $params['supplier_category_id'];
        $goods_supplier->contact = $params['contact'];
        $goods_supplier->mobile = $params['mobile'];
        $goods_supplier->landline = $params['landline'];
        $goods_supplier->email = $params['email'];
        $goods_supplier->province_id = $params['province_id'];
        $goods_supplier->city_id = $params['city_id'];
        $goods_supplier->district_id = $params['district_id'];
        $goods_supplier->address = $params['address'];
        $goods_supplier->bank_account = $params['bank_account'];
        $goods_supplier->bank = $params['bank'];
        $goods_supplier->cardholder_name = $params['cardholder_name'];
        $goods_supplier->tax_id = $params['tax_id'];
        $goods_supplier->sort = $params['sort'];
        return $goods_supplier->save();
    }

    /**
     * @notes 查看供应商详情
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function detail($params)
    {
        return GoodsSupplier::find($params['id'])->toArray();
    }
}