<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic;

use app\common\enum\DefaultEnum;
use app\common\enum\YesNoEnum;
use app\common\logic\BaseLogic;
use app\common\model\CircleCate;
use app\common\service\FileService;

class CircleCateLogic extends BaseLogic
{


    /**
     * @notes 查看详情
     * @param $params
     * @return array
     */
    public static function detail($params)
    {
        $data =CircleCate::findOrEmpty($params['id'])->toArray();
        return  $data;
    }

    /**
     * @notes 添加
     * @param $params
     */
    public static function add($params)
    {
        // echo '添加的参数';
        // dd($params);
        // $image = isset($params['icon']) && !empty($params['icon']) ? FileService::setFileUrl($params['icon']) : '';
        $data = [
            'name' => $params['name'],
            'pid' => $params['pid'],
            // 'synopsis' => $params['synopsis'],
            // 'icon' => $image,
            'sort' => $params['sort'] ?? DefaultEnum::SORT,
            'is_show' => $params['is_show'] ?? YesNoEnum::YES,
            // 'home_show' => $params['home_show'] ?? YesNoEnum::YES,
            'create_time' => time()
        ];

        CircleCate::create($data);
    }


    /**
     * @notes 编辑
     * @param $params
     */
    public static function edit($params)
    {
        $image = isset($params['icon']) && !empty($params['icon']) ? FileService::setFileUrl($params['icon']) : '';

        $data = [
            'name' => $params['name'],
            'pid' => $params['pid'],
            // 'synopsis' => $params['synopsis'],
            // 'icon' => $image,
            'sort' => $params['sort'] ?? DefaultEnum::SORT,
            'is_show' => $params['is_show'] ?? YesNoEnum::YES,
            // 'home_show' => $params['home_show'] ?? YesNoEnum::YES,
            // 'create_time' => time()
        ];

        CircleCate::update($data,['id' => $params['id']]);
    }

    /**
     * @notes 删除
     * @param $params
     */
    public static function delete($params)
    {
        CircleCate::destroy($params['id']);
    }

    /**
     * @notes 修改是否显示状态
     * @param $params
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function status($params)
    {
        $article = CircleCate::find($params['id']);
        $article->save(['is_show' => $params['is_show']]);
    }


}