<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\lists\user;

use app\adminapi\lists\BaseAdminDataLists;
use app\common\lists\ListsExcelInterface;
use app\common\lists\ListsSearchInterface;
use app\common\model\
{
    UserLabel,
    UserLabelIndex
};


/**
 * 标签列表
 * Class UserLabelLists
 * @package app\adminapi\lists\user
 */
class UserLabelLists extends BaseAdminDataLists implements ListsSearchInterface, ListsExcelInterface
{
    public function setSearch(): array
    {
        return [
            '%like%' => ['name']
        ];
    }
    /**
     * @notes 列表
     * @return array
     */
    public function lists(): array
    {
        $lists = UserLabel::field('id,name,label_type')
            ->where($this->searchWhere)
            ->limit($this->limitOffset, $this->limitLength)
            ->order('id', 'desc')
            ->select()
            ->toArray();

        $labelCount = UserLabelIndex::group('label_id')->column('count(id) as num', 'label_id');

        foreach ($lists as $key => $label) {
            $lists[$key]['num'] = $labelCount[$label['id']] ?? 0;
        }

        return $lists;
    }

    /**
     * @notes 搜索条数
     * @return int
     */
    public function count(): int
    {
        return UserLabel::where($this->searchWhere)->count();
    }

    /**
     * @notes 设置excel表名
     * @return string
     */
    public function setFileName(): string
    {
        return '用户标签';
    }

    /**
     * @notes 设置导出字段
     * @return array
     */
    public function setExcelFields(): array
    {
        return [
            'name'      => '标签名称',
            'num'       => '用户数',
        ];
    }
}