<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\lists\ad;

use app\adminapi\lists\BaseAdminDataLists;
use app\common\enum\AdEnum;
use app\common\model\Ad;
use app\common\model\AdPosition;
/**
 * 广告位列表
 */
class AdLists extends BaseAdminDataLists
{


    /**
     * @notes 附加搜索条件
     */
    public function setSearch()
    {
        if (isset($this->params['name']) && !empty($this->params['name'])) {
            $this->searchWhere[] = ['name', 'like', '%' . trim($this->params['name']) . '%'];
        }

        if (isset($this->params['pid']) && !empty($this->params['pid'])) {
            $this->searchWhere[] = ['pid', '=',($this->params['pid']) ];
        }
    }

    /**
     * @notes 列表
     */
    public function lists(): array
    {
        $this->setSearch();

    
        $lists = Ad::where($this->searchWhere)
            ->order('id', 'asc')
            ->limit($this->limitOffset, $this->limitLength)
            ->select()
            ->toArray();

        foreach ($lists as &$item) {
            $item['client_name'] =  AdEnum::getAdTypeDesc($item['client']);

            $item['position_name'] =  AdPosition::where(['id' => $item['pid']])->value('name');
        }
      
        return $lists;
    }


    /**
     * @notes 总记录数
     */
    public function count(): int
    {
        $this->setSearch();
        $count = Ad::where($this->searchWhere)->count();
        return $count;
    }
}
