<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\user;
use app\adminapi\{
    validate\user\UserLevelValidate,
    logic\user\UserLevelLogic,
    controller\BaseAdminController,
};

/**
 * 会员等级控制器
 * Class UserLevelController
 * @package app\adminapi\controller\user
 */
class UserLevel extends BaseAdminController
{
    /**
     * @notes 用户等级列表
     * @return \think\response\Json
     */
    public function lists()
    {
        return $this->dataLists();
    }


    /**
     * @notes 添加会员等级
     * @return \think\response\Json
     */
    public function add()
    {
        $params = (new UserLevelValidate())->post()->goCheck('add');
        (new UserLevelLogic)->add($params);
        return $this->success('添加等级成功',[],1,1);
    }


    /**
     * @notes 获取会员等级
     * @return \think\response\Json
     */
    public function detail()
    {
        $id = $this->request->get('id');
        $detail = (new UserLevelLogic())->detail($id);
        return $this->success('',$detail);
    }

    /**
     * @notes 修改会员等级
     * @return \think\response\Json
     */
    public function edit()
    {
        $params = (new UserLevelValidate())->post()->goCheck();
        (new UserLevelLogic)->edit($params);
        return $this->success('修改等级成功',[],1,1);
    }

    /**
     * @notes 删除会员等级
     * @return \think\response\Json
     */
    public function del(){
        $params = (new UserLevelValidate())->post()->goCheck('del');
        (new UserLevelLogic())->del($params['id']);
        return $this->success('删除成功');
    }


}