<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\settings\user;
use app\adminapi\{
    controller\BaseAdminController,
    logic\settings\user\UserLogic,
    validate\settings\user\UserConfigValidate
};


/**
 * 设置-用户设置控制器
 * Class UserController
 * @package app\adminapi\controller\config
 */
class User extends BaseAdminController
{

    /**
     * @notes 获取用户设置
     * @return \think\response\Json
     */
    public function getConfig()
    {
        $result = (new UserLogic())->getConfig();
        return $this->data($result);
    }

    /**
     * @notes 设置用户设置
     * @return \think\response\Json
     */
    public function setConfig()
    {
        $params = (new UserConfigValidate())->post()->goCheck('user');
        (new UserLogic())->setConfig($params);
        return $this->success('设置成功',[],1,1);

    }

    /**
     * @notes 获取注册配置
     * @return \think\response\Json
     */
    public function getRegisterConfig()
    {
        $result = (new UserLogic())->getRegisterConfig();
        return $this->data($result);
    }

    /**
     * @notes 设置注册配置
     * @return \think\response\Json
     */
    public function setRegisterConfig()
    {
        $params = (new UserConfigValidate())->post()->goCheck('register');
        (new UserLogic())->setRegisterConfig($params);
        return $this->success('设置成功',[],1,1);
    }

    /**
     * @notes 获取用户邀请配置
     * @return \think\response\Json
     */
    public function getInviteConfig()
    {
        $result = (new UserLogic())->getInviteConfig();
        return $this->data($result);
    }

    /**
     * @notes 设置用户邀请配置
     * @return \think\response\Json
     */
    public function setInviteConfig()
    {
        $params = (new UserConfigValidate())->post()->goCheck('register');
        (new UserLogic())->setInviteConfig($params);
        return $this->success('设置成功',[],1,1);
    }

    



}