<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\emo;

use app\adminapi\controller\BaseAdminController;


class EmoImage extends BaseAdminController
{
    
    public function list($cid)
    {
        $list = \app\common\model\EmoImage::where('category_id',$cid)
        ->select()->toArray();
        return show(config('status.success'),'list',$list);
    }

    public function detail($id)
    {
        $data = \app\common\model\EmoImage::find($id);

        return show(config('status.success'),'',$data);
    }

    public function del($id)
    {
        \app\common\model\EmoImage::where('id',$id)->delete();

        return show(config('status.success'),'删除成功');
    }

    public function update()
    {
        $params = $this->request->post();
        \app\common\model\EmoImage::update($params);
        
        return show(config('status.success'),'修改成功');
    }

    public function add()
    {
        $data = $this->request->post('data');
        
        \app\common\model\EmoImage::saveAll($data);

        return show(config('status.success'),'批量添加成功');
    }

    /**
     * 批量添加
     * @return \think\response\Json
     */
    public function addAll()
    {
        $data = $this->request->post('data');
        
        \app\common\model\EmoImage::saveAll($data);

        return show(config('status.success'),'批量添加成功');
    }

    /**
     * 一键删除
     */
    public function delAll($cid)
    {
        $list = \app\common\model\EmoImage::where('category_id',$cid)->delete();

        return show(config('status.success'),'删除分类下的所有图片成功');
    }

}