<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller;

/**
 * 首页导航菜单
 * Class GoodsController
 * @package app\adminapi\controller\goods
 */
class StartAd extends BaseAdminController
{
    public function add()
    {
        $params = $this->request->post();
        \app\common\model\StartAd::create($params);

        return show(config('status.success'),'添加成功');
    }

    public function list()
    {
        $list = \app\common\model\StartAd::paginate(10);
        return show(config('status.success'),'',$list);
    }
    
    public function detail($id)
    {
        $data = \app\common\model\StartAd::find($id);
        return show(config('status.success'),$data);
    }

    public function del($id)
    {
        $data = \app\common\model\StartAd::find($id)->delete();
        return show(config('status.success'),$data);
    }

    public function update()
    {
        $params = $this->request->post();
        $data = \app\common\model\StartAd::update($params);
        return show(config('status.success'),$data);
    }
    
}


