<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\websocket;


use app\common\enum\ChatMsgEnum;

class Response
{
    /**
     * @notes 结果数据
     * @param string $msg
     * @param array $data
     * @param int $code
     * @return array
     */
    private function result(string $msg = 'OK', array $data = [], int $code = 10001)
    {
        $result = [
            'code' => $code,
            'msg' => $msg,
            'data' => $data
        ];
        return $result;
    }


    /**
     * @notes 成功
     * @param string $msg
     * @param array $data
     * @param int $code
     * @return array
     */
    public function success(string $msg = 'OK', array $data = [], int $code = 10001)
    {
        return $this->result($msg, $data, $code);
    }


    /**
     * @notes 错误
     * @param string $msg
     * @param array $data
     * @param int $code
     * @return array
     */
    public function error(string $msg = 'Error', array $data = [], int $code = 20001)
    {
        return $this->result($msg, $data, $code);
    }


    /**
     * @notes 整理返送错误信息
     * @param string $msg
     * @param int $msg_type
     * @return array
     */
    public function formatSendError(string $msg, int $msg_type = 0)
    {
        if (empty($msg_type)) {
            $msg_type = ChatMsgEnum::TYPE_TEXT;
        }

        return [
            'msg' => $msg,
            'msg_type' => $msg_type,
        ];
    }

}
