<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\service\security\engine;

use app\common\service\FileService;
use TencentCloud\Common\Credential;
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Tms\V20201229\TmsClient;
use TencentCloud\Tms\V20201229\Models\TextModerationRequest;
use TencentCloud\Ims\V20201229\ImsClient;
use TencentCloud\Ims\V20201229\Models\ImageModerationRequest;




/**
 * 阿里云安全内容审核
 * @package app\common\library\security\engine
 */
class Qcloud
{
    private $config;
    protected $error = null;

    /**
     * 构造方法
     * Aliyun constructor.
     * @param $config
     */
    public function __construct($config)
    {
        $this->config = $config;
    }

    /**
     * @notes 获取错误信息
     * @return mixed
     */
    public function getError()
    {
        return $this->error;
    }

    /**
     * 内容检测  全部， 文本 图片 视频
     * @param $text (需要检测的内容)
     * @return false|mixed
     */
    public function all( array $all=[] )
    {
        if( isset($all['text'])  && $all['text'] ){
            if( !$this->textModeration($all['text'])){
                return false;
            }
        }
        

        if( isset($all['img'])  && $all['img'] ){
            foreach( $all['img'] as $img){
                $img = FileService::getFileUrl($img) ;
                if( !$this->imageModeration($img)){
                    return false;
                }
            } 
        }

        return true;

    }

    /**
     * TextModerationRequest  文本内容检测
     * @param $text (需要检测的内容)
     * @return false|mixed
     */
    public function textModeration( $text )
    {

        try {
            $cred = new Credential($this->config['secret_id'], $this->config['secret_key']);
            $httpProfile = new HttpProfile();
            $httpProfile -> setEndpoint("tms.tencentcloudapi.com");
            $clientProfile = new ClientProfile();
            $clientProfile -> setHttpProfile($httpProfile);
            $client = new TmsClient($cred, $this->config['region'], $clientProfile);
            $req = new TextModerationRequest();
            $params = [
                'Content' => base64_encode($text)
            ];
            $req -> fromJsonString(json_encode($params));
            $resp = $client -> TextModeration($req);

            if( $resp->Label =='Normal'){
                return true;
            }

            $this->error = $resp->Label;
            return false;
        } catch (TencentCloudSDKException $e) {
           
            $this->error = $e->getMessage();
            return false;

        }
        

    }



    /**
     * 图片检测
     * @param $url 图片地址
     */
    function imageModeration( $url ){
        try {
            $cred = new Credential($this->config['secret_id'], $this->config['secret_key']);
            $httpProfile = new HttpProfile();
            $httpProfile -> setEndpoint("ims.tencentcloudapi.com");
            $clientProfile = new ClientProfile();
            $clientProfile -> setHttpProfile($httpProfile);
            $client = new ImsClient($cred, $this->config['region'], $clientProfile);
            $req = new ImageModerationRequest();
            $params = [
                'FileUrl' => ($url)
            ];
            $req -> fromJsonString(json_encode($params));
            $resp = $client -> ImageModeration($req);

            if( $resp->Label =='Normal'){
                return true;
            }

            $this->error = $resp->Label;
            return false;
        } catch (TencentCloudSDKException $e) {
           
            $this->error = $e->getMessage();
            return false;

        }

    }



}
