<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\service\security;

use think\Exception;

/**
 * 存储模块驱动
 * Class driver
 * @package app\common\library\storage
 */
class Driver
{
    private $config;    // upload 配置
    private $engine;    // 当前引擎类

   
    /**
     * 构造方法
     * Driver constructor.
     * @param $config
     * @param null|string $storage 指定存储方式，如不指定则为系统默认
     * @throws Exception
     */
    public function __construct($config, $storage = null)
    {
        
        
        $this->config = $config;
        $this->engine = $this->getEngineClass($storage);
    }

    /**
     * 内容检测
     * @param $text 检测内容
     * @return mixed
     */
    public function all($params)
    {
        return $this->engine->all($params);
    }

    
    /**
     * 文本内容检测
     * @param $text 检测内容
     * @return mixed
     */
    public function textModeration($text)
    {
        return $this->engine->textModeration($text);
    }


    /**
     * 获取当前的存储引擎
     * @param null|string $storage 指定存储方式，如不指定则为系统默认
     * @return mixed
     * @throws Exception
     */
    private function getEngineClass($secrity = null)
    {

        $engineName = is_null($secrity) ? $this->config['default'] : $secrity;
        
        
        $classSpace = __NAMESPACE__ . '\\engine\\' . ucfirst($engineName);

        // dd($classSpace);
        
        if (!class_exists($classSpace)) {
            throw new Exception('未找到引擎类: ' . $engineName);
        }

        return new $classSpace($this->config['engine'][$engineName]);
    }

    /**
     * @notes 获取错误信息
     * @return mixed
     */
    public function getError()
    {
        return $this->engine->getError();
    }

}
