<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;

use app\common\service\FileService;
use think\model\concern\SoftDelete;

class TwoOrderGoods extends BaseModel
{
    // use SoftDelete;

    protected $deleteTime = 'delete_time';

    /**
     * @notes 获取商品信息快照
     * @param $value
     * @return mixed
     */
    public function getGoodsSnapAttr($value)
    {
        $goodsSnap = $value->value();

        if(!empty($goodsSnap)) {
            // $goodsSnap = json_decode($goodsSnap, true);
            $goodsSnap['use_image'] = !empty($goodsSnap['spec_image']) ? $goodsSnap['spec_image'] : $goodsSnap['image'];
            $goodsSnap['use_image'] = FileService::getFileUrl($goodsSnap['use_image']);
            $goodsSnap['goods'] = TwoGoods::findOrEmpty($goodsSnap['goods_id']);
            $goodsSnap['user'] = User::field('id,nickname,avatar')->findOrEmpty($goodsSnap['user_id']);
        }
        return $goodsSnap;
    }

    /**
     * @notes 订单商品图片获取器
     * @param $value
     * @param $data
     * @return mixed
     */
     public function getGoodsImageAttr($value, $data)
     {
         $goods_image = empty($data['goods_snap']->value()['image']) ? '' : $data['goods_snap']->value()['image'];
         return empty($goods_image) ? '' : FileService::getFileUrl($goods_image);
     }

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    public function sellUser()
    {
        return $this->hasOne(User::class, 'id', 'sell_user_id');
     }

    /**
     * @notes 订单商品规格获取器
     * @param $value
     * @param $data
     * @return string
     */
    // public function getSpecValueStrAttr($value, $data)
    // {
    //     return $data['goods_snap']->spec_value_str;
    // }

    /**
     * @notes 商品名称获取器
     * @param $value
     * @param $data
     * @return mixed
     */
    // public function getGoodsNameAttr($value, $data)
    // {
    //     return $data['goods_snap']->goods_name;
    // }

    /**
     * @notes 商品编码
     * @param $value
     * @param $data
     * @return string
     */
    // public function getCodeAttr($value, $data)
    // {
    //     return $data['goods_snap']->code ?? '';
    // }

    /**
     * @notes 商品原价
     * @param $value
     * @param $data
     * @return mixed
     */
    // public function getOriginalPriceAttr($value, $data)
    // {
    //     return $data['goods_snap']->original_price ?? 0;
    // }
}