<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;

use app\common\enum\PayEnum;
use think\model\concern\SoftDelete;

/**
 * 帖子订单模型
 * Class ArticleOrder
 * @package app\common\model
 */
class ArticleOrder extends BaseModel
{
    use SoftDelete;

    protected $deleteTime = 'delete_time';


    /**
     * @notes 充值金额获取器
     * @param $value
     * @return int|mixed|string
     */
    public function getOrderAmountAttr($value)
    {
        return clear_zero($value);
    }

    /**
     * @notes 支付方式获取器
     * @param $value
     * @return string|string[]
     */
    public function getPayWayAttr($value)
    {
        return PayEnum::getPayDesc($value);
    }

    /**
     * @notes 支付状态获取器
     * @param $value
     * @return string|string[]
     */
    public function getPayStatusAttr($value)
    {
        return PayEnum::getPayStatusDesc($value);
    }
}