<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\listener\websocket;


use app\common\logic\ChatLogic;
use app\common\model\ChatRelation;

/**
 * 用户上线
 * Class UserOnline
 * @package app\common\listener\websocket
 */
class UserOnline
{
    public function handle($params)
    {
        $handleClass = $params['handle'];
        $fd = $params['fd'];

        // 当前用户信息
        $user = $handleClass->getDataByFd($fd);

        // 接收人信息
        $toId = $params['data']['receiveId'] ?? 0;

        if (empty($user['type'] || $user['type'] != 'user' || empty($toId))) {
            return true;
        }

        // 是否有绑定关系
        $relationId = ChatLogic::bindRelation($user['uid'], $toId, [
            'terminal' => $user['terminal'],
        ], 1);

        $relation = ChatRelation::where(['id' => $relationId])->findOrEmpty();

        $toFd = $handleClass->getFdByUid($toId, 'receive');
        if (!empty($toFd)) {
            $relation['online'] = 1;
            return $handleClass->pushData($toFd, 'user_online', $relation);
        }
        return true;
    }
}