<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\enum;


/**
 * 商品枚举
 * Class TwoGoodsEnum
 * @package app\common\enum
 */
class TwoGoodsEnum
{
    const GOODS_REALITY     = 1;     

    const STATUS_SELL       = 1;
    const STATUS_STORAGE    = 0;

    const SEPC_TYPE_SIGNLE  = 1;
    const SEPC_TYPE_MORE    = 2;
    const SPEC_SEPARATOR    = ','; //规格名称分隔符

    const AFTER_PAY_AUTO            = 1;    //自动发货
    const AFTER_PAY_HANDOPERSTION   = 2;    //手动发货

    const AFTER_DELIVERY_AUTO           = 1;    //自动完成订单
    const AFTER_DELIVERY_HANDOPERSTION  = 2;    //需要买家确认


    /**
     * @notes 商品规格类型
     * @param bool $from
     * @return array|mixed|string
     */
    public static function getSpecTypeDesc($from = true)
    {
        $desc = [
            self::SEPC_TYPE_SIGNLE      =>  '单规格',
            self::SEPC_TYPE_MORE        =>  '多规格',
        ];
        if(true === $from){
            return $desc;
        }
        return $desc[$from] ?? '';
    }

    /**
     * @notes 商品状态
     * @param bool $from
     * @return array|mixed|string
     */
    public static function getStatusDesc($from = true)
    {
        $desc = [
            self::STATUS_SELL       => '销售中',
            self::STATUS_STORAGE    => '仓库中',
        ];
        if(true === $from){
            return $desc;
        }
        return $desc[$from] ?? '';
    }


    /**
     * @notes 获取商品类型
     * @param bool $from
     * @return array|mixed|string
     * @author lgp
     * @date 2022/4/19 12:09
     */
    public static function getGoodsTypeDesc($from = true){
        $desc = [
            self::GOODS_REALITY     => '实物商品'
        ];
        if(true === $from){
            return $desc;
        }
        return $desc[$from] ?? '';
    }



}
