<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */



namespace app\common\enum;


/**
 * 订单枚举
 * Class OrderEnum
 * @package app\common\enum
 */
class OrderEnum
{
    //订单类型
    const NORMAL_ORDER = 0; //普通订单



    //订单状态
    const STATUS_WAIT_PAY       = 0;  //待付款
    const STATUS_WAIT_DELIVERY  = 1;  //待发货
    const STATUS_WAIT_RECEIVE   = 2;  //待收货
    const STATUS_FINISH         = 3;  //已完成
    const STATUS_CLOSE          = 4;  //已关闭

    //按钮(显示/隐藏)
    const BTN_HIDE = 0;
    const BTN_SHOW = 1;



    // 订单类型
    const ORDER_TYPE = [
        self::NORMAL_ORDER
    ];


    /**
     * @notes 订单类型
     * @param bool $value
     * @return array|mixed
     */
    public static function getOrderTypeDesc($value = true)
    {
        $data = [
            self::NORMAL_ORDER => '普通订单'
        ];
        if (true === $value) {
            return $data;
        }
        return $data[$value];
    }

    /**
     * @notes 订单状态
     * @param bool $value
     * @return string|string[]
     */
    public static function getOrderStatusDesc($value = true)
    {
        $data = [
            self::STATUS_WAIT_PAY => '待付款',
            self::STATUS_WAIT_DELIVERY => '待发货',
            self::STATUS_WAIT_RECEIVE => '待收货',
            self::STATUS_FINISH => '已完成',
            self::STATUS_CLOSE => '已关闭',
        ];
        if (true === $value) {
            return $data;
        }
        return $data[$value];
    }
}