<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\enum;

use app\common\model\Admin;
use app\common\model\User;

/**
 * 售后日志枚举
 * Class AfterSaleLogEnum
 * @package app\common\enum
 */
class AfterSaleLogEnum
{
    /**
     * 整单退款场景
     */
    const BUYER_CANCEL_ORDER = 1;
    const SELLER_CANCEL_ORDER = 2;
    const ORDER_CLOSE = 3;

    /**
     * 操作人角色
     * ROLE_SYS 系统
     * ROLE_BUYER 买家
     * ROLE_SELLER 卖家
     */
    const ROLE_SYS = 1;
    const ROLE_BUYER = 2;
    const ROLE_SELLER = 3;

    /**
     * @notes 获取场景描述
     * @param $value
     * @return string
     */
    public static function getSenceDesc($value)
    {
        $desc = [
            self::BUYER_CANCEL_ORDER => '买家取消订单',
            self::SELLER_CANCEL_ORDER => '卖家取消订单',
            self::ORDER_CLOSE => '支付回调时订单已关闭',
        ];

        return $desc[$value] ?? '';
    }

    /**
     * @notes 获取操作者名称
     * @param $operatorID
     * @param $operatorRole
     * @return mixed|string
     */
    public static function getOpertorName($operatorID, $operatorRole)
    {
        switch ($operatorRole) {
            case self::ROLE_SYS:
                return '系统';
            case self::ROLE_BUYER:
                return User::where('id', $operatorID)->value('nickname');
            case self::ROLE_SELLER:
                return Admin::where('id', $operatorID)->value('name');
        }
        return '';
    }
}