<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\validate;
use app\common\model\User;
use app\common\validate\BaseValidate;

/**
 * 设置用户基础信息验证器
 * Class SetUserInfoValidate
 * @package  app\api\validate
 */
class SetUserInfoValidate extends BaseValidate
{
    protected $rule = [
        'field'             => 'require|checkField',
        'value'             => 'require',
    ];

    protected $message = [
        'field.require'     => '参数缺失',
        'value.require'     => '值不存在',
    ];


    /**
     * @notes 校验字段
     * @param $value
     * @param $rule
     * @param $data
     * @return bool|string
     */
    protected function checkField($value,$rule,$data)
    {
        $allowField = [
            'nickname','sex','avatar','mobile','real_name','home_bg','notice_comment_auth_check','private_like','private_follow','private_collect','private_fans','private_visitor','withdraw_wepay_code','withdraw_alipay_code','withdraw_name','withdraw_alipay_account','desc','birth','career','height','weight','images'
        ];
        if(!in_array($value,$allowField)){
            return '参数错误';
        }
        if($value != 'mobile') {
            return true;
        }
        $user = User::where([
            ['mobile', '=', $data['value']],
            ['id', '<>', $data['id']]
        ])->findOrEmpty();
        if($user->isEmpty()) {
            return true;
        }
        return '该手机号已被绑定';
    }



}