<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\logic;

use app\common\enum\DefaultEnum;
use app\common\logic\BaseLogic;
use app\common\model\Topic;
use Think\Log;

class TopicLogic extends BaseLogic
{
   

    /**
     * @notes 热门话题,参数话题的帖子排序
     * @param $params
     */
    public static function hot($params)
    {
        $list = Topic::alias('t')->join('topic_article', 't.id = topic_article.topic_id')
                ->field('t.id,t.name,synopsis, COUNT(topic_article.id) AS topic_article_count')
                ->group('t.id')
                ->order('topic_article_count', 'desc')
                ->limit(20)
                ->select()->toArray();

        return $list;
    }

    /**
     * @notes 发布话题
     * @param $params
     */
    public static function add($params)
    {
        $data = [
            'name'     => $params['name'],
            'sort'     => $params['sort'] ?? DefaultEnum::SORT,
            'create_time' => time()
        ];

        return Topic::create($data);
    }


    /**
     * 详情
     */
    public static function detail($params )
    {
        $data = Topic::where('id',$params['id'])->find();

        $data->inc('hot',1);
        $data->save();

        $data = $data->toArray();
        
        return $data;
    }


}