<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\logic;

use app\common\logic\BaseLogic;
use app\common\model\User;
use app\common\model\UserFollow;

/**
 * 排行榜
 * Class FansLists
 * @package app\api\lists
 */
class RankingLogic extends BaseLogic
{

    /**
     * @notes 粉丝列表
     * @return array
     */
    public static function lists($params): array
    {

        if( isset( $params['type']) &&  $params['type'] == 0){

            $lists = User::alias('u')->join('user_follow', 'u.id = user_follow.user_id')
                    ->field('u.id,avatar,nickname, COUNT(user_follow.id) AS fans_count')
                    ->group('u.id')
                    ->order('fans_count', 'desc')
                    ->limit(50)
                    ->select()->toArray();
            

        } else {
          
            $order = 'user_money desc';
            $field = 'id,avatar,nickname,user_money';
            $lists = User::order('user_money', 'desc')->limit(50)->field($field)->select()->toArray();

        }
        

        // 取指定页数据
        return $lists;
    }

   
}