<?php

namespace app\api\controller\twoshop;

use app\api\controller\BaseShopController;
use app\common\model\TwoGoods;
use app\common\model\TwoOrder;
use app\common\model\TwoPromiseMoneyBackRequest;
use app\common\model\TwoPromiseMoneyOrder;
use app\common\model\TwoPromiseMoneyRecord;
use app\common\service\ConfigService;

class PromiseMoney extends BaseShopController
{
    public function createOrder()
    {
        $params = $this->request->post();

        if ($params['amount'] < 0.01) {
            return show(config('status.error'), '金额不能少于0.01');
        }

        $minPromiseMoney = ConfigService::get('twoshop', 'min_promise_money', 0);

        $detail = TwoPromiseMoneyRecord::where('user_id', $this->userId)->find();

        if ($detail && $minPromiseMoney - $detail->money > $params['amount']) {
            return show(0, '缴纳金额不能少于 ' . ($minPromiseMoney - $detail->money));
        }

        if (!$detail && $minPromiseMoney > $params['amount']) {
            return show(0, '缴纳金额不能少于 ' . $minPromiseMoney);
        }

        try {
            $order_data = [
                'sn' => time() . round(10000, 99999),
                'user_id' => $this->userId,
                'order_amount' => $params['amount'],
                'message' => isset($params['message']) ? $params['message'] : '',
            ];
            $res = \app\common\model\TwoPromiseMoneyOrder::create($order_data);

            if (!$res) {
                return show(config('status.error'), '订单创建失败');
            }

            return show(config('status.success'), '订单创建成功', [
                'order_id' => $res->id,
            ]);
        } catch (\Exception $e) {
            return show(config('status.error'), $e->getMessage());
        }
    }

    public function listOrder()
    {
        $data = TwoPromiseMoneyOrder::where('user_id', $this->userId)->select();

        return show(1, '保证金列表', $data);
    }

    public function detail()
    {
        $params = $this->request->param();

        if (!empty($params['user_id'])) {
            $uid = $params['user_id'];
        } else {
            $uid = $this->userId;
        }

        $res = TwoPromiseMoneyRecord::where('user_id', $uid)->find();
        if (!$res) {
            return show(0, '未缴纳');
        }
        return show(1, '保证金详情', $res);
    }

    public function back()
    {
        $params = $this->request->post();

        if ($params['amount'] < 0.01) {
            return show(config('status.error'), '金额不能少于0.01');
        }

        $minPromiseMoney = ConfigService::get('twoshop', 'min_promise_money', 0);
        $detail = TwoPromiseMoneyRecord::where('user_id', $this->userId)->find();

        if (!$detail) {
            return show(0, '未缴纳');
        }

        $newMoney = $detail->money - $params['amount'];

        if ($newMoney < 0) {
            return show(0, '保证金不足');
        }

        if ($newMoney != $minPromiseMoney) {
            $availableGoodsCount = TwoGoods::where('user_id', $this->userId)->where('status', 1)->count();

            if ($availableGoodsCount > 0) {
                return show(config('status.error'), '存在未下架的商品');
            }

            $availableOrderCount = TwoOrder::where('sell_user_id', $this->userId)->where('order_status', 'in', [0, 1, 2])->count();

            if ($availableOrderCount > 0) {
                return show(config('status.error'), '存在未处理的订单');
            }
        }

        $detail->money -= $params['amount'];
        $detail->save();

        TwoPromiseMoneyBackRequest::create([
            'user_id' => $this->userId,
            'money' => $params['amount'],
        ]);

        return show(1, '申请成功');
    }

    public function backList()
    {
        $data = TwoPromiseMoneyBackRequest::where('user_id', $this->userId)->select();
        return show(1, '申请列表', $data);
    }

    public function backDetail($id)
    {
        $res = TwoPromiseMoneyRecord::where('user_id', $this->userId)->find($id);
        if (!$res) {
            return show(0, '查询失败');
        }
        return show(1, '查询成功', $res);
    }
}