<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */
namespace app\api\controller\twoshop;


class GoodsVisit extends \app\api\controller\BaseShopController
{

    public function list()
    {
        $list = \app\common\model\TwoGoodsVisit::where('user_id',$this->userId)
        ->with('goods')
        ->order('update_time','desc')
        ->order('create_time','desc')
        ->paginate(10);

        foreach ($list as &$item) {
            $item['isZan'] = !!\app\common\model\TwoGoodsCollect::where('goods_id',$item['goods_id'])
            ->where('user_id',$this->userId)
            ->where('type',2)
            ->find();

            $item['isMessage'] = !!\app\common\model\TwoGoodsMessage::where('goods_id',$item['goods_id'])
            ->where('user_id',$this->userId)
            ->find();
        }

       return show(1,'商品收藏',$list);
    }

}