<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller\pointsshop;

// use app\api\lists\OrderLists;
use app\api\logic\twoshop\OrderLogic;
use app\api\validate\twoshop\PlaceOrderValidate;
use app\api\validate\twoshop\OrderValidate;

/**
 * 订单
 * Class OrderController
 * @package app\api\controller
 */
class Log extends \app\api\controller\BaseShopController
{

    public function list()
    {
        $params = $this->request->param();

        $where = [];

        if (isset($params['type'])) {
            $where[] = ['transaction_type','=',$params['type']];
        }

        if (isset($params['source'])) {
            $where[] = ['transaction_source','=',$params['source']];
        }

        $list = \app\common\model\PointsLog::where('user_id',$this->userId)
            ->where($where)
            ->paginate(10);

        return show(config('status.success'),'积分流水记录',$list);
    }

}