<?php

namespace app\api\controller;

use app\common\model\FakeUserAvatar;
use app\common\model\FakeUserName;

class FakeUser extends BaseShopController
{
    public function availableAvatars()
    {
        $data = FakeUserAvatar::select();
        return show(1, '头像库', $data);
    }

    public function availableNames()
    {
        $data = FakeUserName::select();
        return show(1, '头像库', $data);
    }

    public function create()
    {
        $params = $this->request->post();

        if (!isset($params['avatar_id']) || !isset($params['name_id'])) {
            return show(0, '参数丢失');
        }

        $avatar = FakeUserAvatar::find($params['avatar_id']);
        $name = FakeUserName::find($params['name_id']);

        if (!$avatar || !$name) {
            return show(0, '参数错误');
        }

        $newUser = \app\common\model\User::find($this->userId);
        $newUser->id = null;
        $newUser->sn = null;
        $newUser->nickname = $name['name'];
        $newUser->avatar = $avatar->avatar;
        $newUser->is_fake_user = true;
        $newUser->fake_user_owner_id = $this->userId;
        $newUserModel = \app\common\model\User::create($newUser);

        $newUserData = $newUserModel->toArray();

        return show(1, '创建成功', $newUserData);
    }

    public function list()
    {
        $data = (new \app\common\model\User)->queryFake()
            ->where('fake_user_owner_id', $this->userId)
            ->select();

        return show(1, '马甲列表', $data);
    }

    public function availableTexts()
    {
        $data = \app\common\model\FakeUserText::select();
        return show(1, '文案库', $data);
    }
}