<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller;
use app\api\{
    logic\CollectLogic,
    lists\GoodsCollectLists
};


/**
 * 聊天内容收藏
 * Class CollectController
 * @package app\api\controller
 */
class ChatCollect extends BaseShopController
{

    /**
     * 我的收藏列表
     */
    public function list()
    {
        $list = \app\common\model\ChatCollect::with(['fromUser'])
        ->where('user_id',$this->userId)
        ->order('create_time','desc')
        ->select()
        ->toArray();
        
        return show(config('status.success'),'我的收藏',$list);
    }

    /**
     * 提手收藏
     */
    public function add()
    {
        $params = $this->request->post();


        if($params['type']=="chat_private"){
            // 私聊聊天信息
            $message = \app\common\model\ChatPrivateMessage::find($params['message_id']);
            if(!$message){
                return show(config('status.error'),'聊天信息不存在');
            }

        }elseif($params['type']=="chat_group"){
            // 群聊聊天信息
            $message = \app\common\model\ChatGroupMessage::find($params['message_id']);
            if(!$message){
                return show(config('status.error'),'群聊天信息不存在');
            }

        }else{
            return show(config("status.error"),"暂不支持此类型收藏");
        }
        
        $data = [
            'user_id'=>$this->userId,
            'type'=>$params['type'],
            'message_id'=>$message->id,
            'content'=>$message->content,
            'message_type'=>$message->type,
        ];
        
        \app\common\model\ChatCollect::create($data);

        return show(config('status.success'),'添加成功');
    }

    /**
     * 删除
     * @param mixed $id
     * @return \think\response\Json
     */
    public function del($id)
    {
        \app\common\model\ChatCollect::where([
            'id'=>$id,
            'user_id'=>$this->userId,
        ])->delete();
        
        return show(config('status.success'),'删除成功');
    }

}