<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\controller;

use app\api\lists\ArticleLists;
use app\common\logic\ChatLogic;
use app\api\logic\DecorateThemeLogic;
use app\api\logic\IndexLogic;

/**
 * 盲盒题库
 * Class IndexController
 * @package app\api\controller
 */
class BlindBoxeQuests extends BaseShopController
{
    public array $notNeedLogin = ['index'];
   
    /**
     * 题库分类列表
     */
    public function category()
    {
        $list = \app\common\model\BlindBoxeQuestsClass::where('status',1)
        ->order('sort','desc')
        ->select();

        return show(1,'',$list);
    }

    public function list()
    {
        $params = input();
        
        $where = [];

        if(isset($params['class_id'])){
            $where[]=[
                'class_id','=',$params['class_id']
            ];
        }
        
        if(isset($params['class_name'])){
            $where[]=[
                'class_name','=',$params['class_name']
            ];
        }

        $list = \app\common\model\BlindBoxeQuests::where($where)
        ->paginate(10);

        return show(1,'',$list);

    }

    /**
     * 问题详情
     */
    public function details($id)
    {
        $data = \app\common\model\BlindBoxeQuests::find($id);
        return show(1,'',$data);
    }

    /**
     * 用户提交答题
     */
    public function addAswer()
    {
        $params = input();

        $data = [
            'user_id'=>$params['user_id'],
            'quest_id'=>$params['quest_id'],
            'content'=>$params['content'],
        ];

        $res = \app\common\model\BlindBoxeQuestAswer::create($data);
        
        return show(1,'添加成功');
        
    }

    /**
     * 答题组合查询结果
     */
    public function questAswerRes()
    {
        $class_id = input('class_id');

        // 查询答题记录
        $aswer = \app\common\model\BlindBoxeQuestAswer::where([
            ['user_id','=',$this->userId],
            ['class_id','=',$class_id]
        ])
        ->order('id','desc')
        ->select();

        if(!$aswer){
            return show(0,'请先答题后查看');
        }
        
        // 通过记录查询匹配结果
        $res = '';
        foreach($aswer as $v){
            if(empty($res)){
                $res.=','.$v['content'].',';
            }else{
                $res.=$v['content'].',';
            }
        }

        $data = \app\common\model\BlindBoxeQuestAswerRes::where([
            ['content','=',$res]
        ])
        ->find();

        return show(1,'',$data);
        

    }
    

}
