<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\validate\user;
use app\common\{
    model\UserLabel,
    model\UserLabelIndex,
    validate\BaseValidate,
};

/**
 * 会员标签验证器
 * Class UserLableValidate
 * @package app\adminapi\validate\user
 */
class UserLableValidate extends BaseValidate
{
    protected $rule = [
        'id'                => 'require',
        'ids'               => 'require',
        'name'              => 'require|max:32|unique:'.UserLabel::class.',name',
        'label_type'        => 'require|in:0,1',
    ];

    protected $message = [
        'id.require'                => '请选择标签',
        'ids.require'               => '请选择标签',
        'name.require'              => '请输入标签名称',
        'name.max'                  => '标签名称最多为32个字符',
        'name.unique'               => '标签名称已存在',
        'label_type.require'        => '请选择标签类型',
        'label_type.in'             => '标签类型错误',
    ];

    //商品添加验证
    public function sceneAdd()
    {
        return $this->remove(['id'=>'require','ids'=>'require']);
    }

    public function sceneDel(){
        return $this->only(['ids']);
    }
    public function sceneEdit()
    {
        return $this->remove(['ids'=>'require']);
    }


}