<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\validate\twoshop;

use app\common\validate\BaseValidate;

/**
 * 售后验证器
 * Class AfterSaleValidate
 * @package app\adminapi\validate\after_sale
 */
class AfterSaleValidate extends BaseValidate
{
    protected $rule = [
        'id' => 'require',
        'refund_total_amount' => 'require|gt:0',
        'refund_way' => 'require|in:1,2'
    ];

    protected $message = [
        'id.require' => '参数缺失',
        'refund_total_amount.require' => '请输入退款金额',
        'refund_total_amount.gt' => '退款金额须大于0',
        'refund_way.require' => '请选择退款方式',
        'refund_way.in' => '退款方式状态值有误',
    ];

    /**
     * @notes 卖家同意售后场景
     * @return AfterSaleValidate
     */
    public function sceneAgree()
    {
        return $this->only(['id']);
    }

    /**
     * @notes 卖家拒绝售后场景
     * @return AfterSaleValidate
     */
    public function sceneRefuse()
    {
        return $this->only(['id']);
    }

    /**
     * @notes 卖家拒绝收货场景
     * @return AfterSaleValidate
     */
    public function sceneRefuseGoods()
    {
        return $this->only(['id']);
    }

    /**
     * @notes 卖家确认收货场景
     * @return AfterSaleValidate
     */
    public function sceneConfirmGoods()
    {
        return $this->only(['id']);
    }

    /**
     * @notes 卖家同意退款场景
     * @return AfterSaleValidate
     */
    public function sceneAgreeRefund()
    {
        return $this->only(['id']);
    }

    /**
     * @notes 卖家拒绝退款场景
     * @return AfterSaleValidate
     */
    public function sceneRefuseRefund()
    {
        return $this->only(['id']);
    }

    /**
     * @notes 卖家确认退款场景
     * @return AfterSaleValidate
     */
    public function sceneConfirmRefund()
    {
        return $this->only(['id', 'refund_total_amount', 'refund_way']);
    }

    /**
     * @notes 售后详情场景
     * @return AfterSaleValidate
     */
    public function sceneDetail()
    {
        return $this->only(['id']);
    }
}