<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */
namespace app\adminapi\logic\settings\shop;

use app\common\enum\YesNoEnum;
use app\common\logic\BaseLogic;
use app\common\service\ConfigService;
use app\common\service\FileService;
use app\common\service\RegionService;

class ShopSettingLogic extends BaseLogic
{
    /**
     * @notes 获取店铺信息
     * @return array
     */
    public static function getShopInfo()
    {
        $config = [
            'name'                  => ConfigService::get('shop', 'name'),
            'logo'                  => ConfigService::get('shop', 'logo'),
            'mobile_logo'           => ConfigService::get('shop', 'mobile_logo'),
            'pc_logo'               => ConfigService::get('shop', 'pc_logo'),
            'pc_article_default_image' => ConfigService::get('shop', 'pc_article_default_image'),
            'admin_login_image'     => ConfigService::get('shop', 'admin_login_image'),
            'login_restrictions'    => ConfigService::get('shop', 'login_restrictions'),
            'password_error_times'  => ConfigService::get('shop', 'password_error_times'),
            'limit_login_time'      => ConfigService::get('shop', 'limit_login_time'),
            'status'                => ConfigService::get('shop', 'status'),
            'close_example_image'   => ConfigService::get('shop', 'close_example_image'),
            'logo_example_image'    => ConfigService::get('shop', 'logo_example_image'),
            'login_example_image'   => ConfigService::get('shop', 'login_example_image'),
            'mall_contact'          => ConfigService::get('shop', 'mall_contact', ''),
            'mall_contact_mobile'   => ConfigService::get('shop', 'mall_contact_mobile', ''),
            'return_contact'        => ConfigService::get('shop', 'return_contact', ''),
            'return_contact_mobile' => ConfigService::get('shop', 'return_contact_mobile', ''),
            'return_province'       => ConfigService::get('shop', 'return_province', ''),
            'return_city'           => ConfigService::get('shop', 'return_city', ''),
            'return_district'       => ConfigService::get('shop', 'return_district', ''),
            'return_address'        => ConfigService::get('shop', 'return_address', ''),
            'favicon'               => ConfigService::get('shop','favicon'),
            'global_login'          => ConfigService::get('shop','global_login'),
            'user_login_image'          => ConfigService::get('shop','user_login_image'),
            'default_user_home_bj' => ConfigService::get('config','default_user_home_bj'),
            'is_demo' => ConfigService::get('config','is_demo'),

            'system_notice_icon' =>  \app\common\service\FileService::getFileUrl(ConfigService::get('default_image','system_notice_icon')),
            'notice_collect_icon' => \app\common\service\FileService::getFileUrl(ConfigService::get('default_image','notice_collect_icon')),
            'notice_comment_icon' => \app\common\service\FileService::getFileUrl(ConfigService::get('default_image','notice_comment_icon')),
            'notice_follow_icon' => \app\common\service\FileService::getFileUrl(ConfigService::get('default_image','notice_follow_icon')),

            'index_notice' =>  ConfigService::get('index','notice'),

            'share_domain' => ConfigService::get('config','share_domain'),

            'footer_contact' => ConfigService::get('info','footer_contact'),
            'footer_copyright' => ConfigService::get('info','footer_copyright'),
            'footer_info' => ConfigService::get('info','footer_info'),

        ];
        $config['logo'] = FileService::getFileUrl($config['logo']);
        $config['mobile_logo'] = FileService::getFileUrl($config['mobile_logo']);
        $config['pc_logo'] = FileService::getFileUrl($config['pc_logo']);
        $config['pc_article_default_image'] = FileService::getFileUrl($config['pc_article_default_image']);
        $config['favicon'] = FileService::getFileUrl($config['favicon']);
        $config['admin_login_image'] = FileService::getFileUrl($config['admin_login_image']);
        $config['close_example_image'] = FileService::getFileUrl($config['close_example_image']);
        $config['logo_example_image'] = FileService::getFileUrl($config['logo_example_image']);
        $config['login_example_image'] = FileService::getFileUrl($config['login_example_image']);
        $config['address'] = RegionService::getAddress([$config['return_province'], $config['return_city'], $config['return_district']], $config['return_address']);

        return $config;
    }

    /**
     * @notes 设置店铺信息
     * @param $params
     */
    public static function setShopInfo($params)
    {
        $params['logo'] = FileService::setFileUrl($params['logo']);
        $params['admin_login_image'] = FileService::setFileUrl($params['admin_login_image']);
        $params['favicon'] = FileService::setFileUrl($params['favicon']);
        $params['pc_article_default_image'] = FileService::setFileUrl($params['pc_article_default_image']);

        ConfigService::set('shop','name', $params['name']);
        ConfigService::set('shop','logo', $params['logo']);
        ConfigService::set('shop','mobile_logo', $params['mobile_logo']);
        ConfigService::set('shop','pc_logo', $params['pc_logo']);
        ConfigService::set('shop','pc_article_default_image', $params['pc_article_default_image']);
        ConfigService::set('shop','favicon', $params['favicon']);
        ConfigService::set('shop','admin_login_image', $params['admin_login_image']);
        ConfigService::set('shop','login_restrictions', $params['login_restrictions']);
        ConfigService::set('shop','status', $params['status']);
        ConfigService::set('shop','mall_contact', $params['mall_contact']);
        ConfigService::set('shop','mall_contact_mobile', $params['mall_contact_mobile']);
        ConfigService::set('shop','return_contact', $params['return_contact']);
        ConfigService::set('shop','return_contact_mobile', $params['return_contact_mobile']);
        ConfigService::set('shop','return_province', $params['return_province']);
        ConfigService::set('shop','return_city', $params['return_city']);
        ConfigService::set('shop','return_district', $params['return_district']);
        ConfigService::set('shop','return_address', $params['return_address']);
        ConfigService::set('shop','global_login', $params['global_login']);
        ConfigService::set('shop','user_login_image', $params['user_login_image']);

        ConfigService::set('default_image','system_notice_icon', $params['system_notice_icon']);
        ConfigService::set('default_image','notice_collect_icon', $params['notice_collect_icon']);
        ConfigService::set('default_image','notice_comment_icon', $params['notice_comment_icon']);
        ConfigService::set('default_image','notice_follow_icon', $params['notice_follow_icon']);

        ConfigService::set('config','default_user_home_bj', $params['default_user_home_bj']);

        ConfigService::set('config','is_demo', $params['is_demo']);

        ConfigService::set('config','share_domain', $params['share_domain']);

        // 首页公告
        ConfigService::set('index','notice', $params['index_notice']);

        if($params['login_restrictions']) {
            ConfigService::set('shop','password_error_times', $params['password_error_times']);
            ConfigService::set('shop','limit_login_time', $params['limit_login_time']);
        }

        // 底部信息配置
        ConfigService::set('info','footer_contact', $params['footer_contact']);
        ConfigService::set('info','footer_copyright', $params['footer_copyright']);
        ConfigService::set('info','footer_info', $params['footer_info']);
        
    }

    /**
     * @notes 获取备案信息
     * @param $params
     * @return array
     */
    public static function getRecordInfo()
    {
        $config = [
            'copyright' => ConfigService::get('shop', 'copyright', ''),
            'record_number' => ConfigService::get('shop', 'record_number', ''),
            'record_system_link' => ConfigService::get('shop', 'record_system_link', ''),
            'business_license' => ConfigService::get('shop', 'business_license'),
            'other_qualifications' => ConfigService::get('shop', 'other_qualifications',[]),
            
            'filing_number' => ConfigService::get('shop', 'filing_number',[]),
            'filing_system_link' => ConfigService::get('shop', 'filing_system_link',[]),
        ];

        $config['business_license'] = $config['business_license'] ? FileService::getFileUrl($config['business_license']) : '';
        if (!empty($config['other_qualifications'])) {
            foreach ($config['other_qualifications'] as &$val) {
                $val = FileService::getFileUrl($val);
            }
        }

        return $config;
    }

    /**
     * @notes 设置备案信息
     * @param $params
     */
    public static function setRecordInfo($params)
    {
        ConfigService::set('shop', 'copyright', $params['copyright'] ?? '');
        ConfigService::set('shop', 'record_number', $params['record_number'] ?? '');
        ConfigService::set('shop', 'record_system_link', $params['record_system_link'] ?? '');
        ConfigService::set('shop', 'business_license', FileService::setFileUrl($params['business_license'] ?? ''));
        ConfigService::set('shop', 'filing_number', FileService::setFileUrl($params['filing_number'] ?? ''));
        ConfigService::set('shop', 'filing_system_link', FileService::setFileUrl($params['filing_system_link'] ?? ''));
        $other_qualifications = [];
        if (!empty($params['other_qualifications'])) {
            foreach ($params['other_qualifications'] as &$val) {
                $val = FileService::setFileUrl($val);
            }
            $other_qualifications = json_encode($params['other_qualifications']);
        }
        ConfigService::set('shop', 'other_qualifications', $other_qualifications);
        return true;
    }

    /**
     * @notes 获取分享设置
     * @return array
     */
    public static function getShareSetting()
    {
        $config = [
            'share_page' => ConfigService::get('shop', 'share_page'),
            'share_title' => ConfigService::get('shop', 'share_title', ''),
            'share_intro' => ConfigService::get('shop', 'share_intro', ''),
            'share_image' => ConfigService::get('shop', 'share_image'),
        ];
        $config['share_image'] = FileService::getFileUrl($config['share_image']);

        return $config;
    }

    /**
     * @notes 分享设置
     * @param $params
     */
    public static function setShareSetting($params)
    {
        ConfigService::set('shop', 'share_page', $params['share_page']);
        ConfigService::set('shop', 'share_title', $params['share_title'] ?? '');
        ConfigService::set('shop', 'share_intro', $params['share_intro'] ?? '');
        ConfigService::set('shop', 'share_image', FileService::setFileUrl($params['share_image']));
    }

    /**
     * @notes 获取政策协议
     * @return array
     */
    public static function getPolicyAgreement()
    {
        $config = [
            'service_agreement_name' => ConfigService::get('shop', 'service_agreement_name', ''),
            'service_agreement_content' => ConfigService::get('shop', 'service_agreement_content', ''),
            'privacy_policy_name' => ConfigService::get('shop', 'privacy_policy_name', ''),
            'privacy_policy_content' => ConfigService::get('shop', 'privacy_policy_content', ''),
            'about_content' => ConfigService::get('shop', 'about_content', ''),
            'circle_create_content' => ConfigService::get('shop', 'circle_create_content', ''),
            'group_create_content' => ConfigService::get('shop', 'group_create_content', ''),
        ];

        return $config;
    }

    /**
     * @notes 设置政策协议
     * @param $params
     */
    public static function setPolicyAgreement($params)
    {
        if(isset($params['service_agreement_name']) && isset($params['service_agreement_content'])) {
            ConfigService::set('shop', 'service_agreement_name', $params['service_agreement_name']);
            ConfigService::set('shop', 'service_agreement_content', $params['service_agreement_content']);
        }

        if(isset($params['privacy_policy_name']) && isset($params['privacy_policy_content'])) {
            ConfigService::set('shop', 'privacy_policy_name', $params['privacy_policy_name']);
            ConfigService::set('shop', 'privacy_policy_content', $params['privacy_policy_content']);
        }

        if(isset($params['about_content']) && isset($params['about_content'])) {
            ConfigService::set('shop', 'about_content', $params['about_content']);
        }

        if(isset($params['circle_create_content'])) {
            ConfigService::set('shop', 'circle_create_content', $params['circle_create_content']);
        }

        if(isset($params['group_create_content'])) {
            ConfigService::set('shop', 'group_create_content', $params['group_create_content']);
        }
    }

    /**
     * @notes 设置地图秘钥
     * @param array $params
     * @return bool
     * @author lgp
     * @date 2022/3/10 5:11 下午
     */
    public static function setMapKey(array $params)
    {
        ConfigService::set('map', 'tencent_map_key', $params['tencent_map_key'] ?? '');
        return true;
    }

    /**
     * @notes 获取地图秘钥
     * @return array
     * @author lgp
     * @date 2022/3/10 5:12 下午
     */
    public static function getMapKey(): array
    {
        return [
            'tencent_map_key' => ConfigService::get('map', 'tencent_map_key',''),
        ];
    }



    /**
     * @notes 设置帖子排序方式
     * @param array $params
     * @return bool
     * @author lgp
     * @date 2022/3/10 5:11 下午
     */
    public static function setArticleConfig(array $params)
    {
        ConfigService::set('article', 'article_index_sort', $params['article_index_sort'] ?? 1);
        
        // 设置帖子免责声明
        ConfigService::set('article', 'disclaimer_status', $params['disclaimer_status'] ?? 1);
        ConfigService::set('article', 'disclaimer_value', $params['disclaimer_value'] ?? '');
        
        // 设置发帖显示标题
        ConfigService::set('article', 'send_examine', $params['send_examine'] ?? 1);

        ConfigService::set('article', 'send_show_title', $params['send_show_title'] ?? 1);

        // 发帖是否需要选择圈子
        ConfigService::set('article', 'send_require_circle', $params['send_require_circle'] ?? 1);

        ConfigService::set('article', 'max_word_len_ellipsis', $params['max_word_len_ellipsis'] ?? 30);
        ConfigService::set('article', 'min_word_len_ellipsis', $params['min_word_len_ellipsis'] ?? 26);

        // 每日发帖次数限制
        ConfigService::set('article', 'send_limit_day', $params['send_limit_day'] ?? 10);
        
        // 发帖奖励积分
        ConfigService::set('article', 'send_get_integral', $params['send_get_integral'] ?? 0);

        // 发帖奖励积分
        ConfigService::set('article', 'send_get_experience', $params['send_get_experience'] ?? 0);

        // 开启视频
        ConfigService::set('article', 'video_status', $params['video_status'] ?? 0);

        // 评论次数相知
        ConfigService::set('article', 'send_comment_limit_day', $params['send_comment_limit_day'] ?? 0);
        // 评论奖励积分
        ConfigService::set('article', 'send_comment_get_integral', $params['send_comment_get_integral'] ?? 0);

        ConfigService::set('article', 'max_image', $params['max_image'] ?? 0);
        
        // 允许修改
        ConfigService::set('article', 'is_update', $params['is_update'] ?? 0);

        // 发帖奖励经验（全局）
        ConfigService::set('article', 'send_get_experience_globle', $params['send_get_experience_globle'] ?? 0);

        ConfigService::set('article', 'send_require_wechat', $params['send_require_wechat'] ?? 0);

        ConfigService::set('article', 'enable_rich_text', $params['enable_rich_text'] ?? 0);

        if(isset($params['article_security']) && isset($params['article_security'])) {
            ConfigService::set('security', 'is_open', $params['article_security'] ?? 0);

            ConfigService::set('security', 'default', "qcloud");
            ConfigService::set('security', 'qcloud', [
                'region' => $params['region'] ?? '',
                'secret_id' => $params['secret_id'] ?? '',
                'secret_key' => $params['secret_key'] ?? '',
                'bucket' => $params['bucket'] ?? '',
            ]);

        }
        
        

        return true;
    }

    /**
     * @notes 获取帖子排序方式
     * @return array
     * @author lgp
     * @date 2022/3/10 5:12 下午
     */
    public static function getArticleConfig(): array
    {       
        return [
            'send_show_title' => ConfigService::get('article', 'send_show_title',1),
            'send_examine' => ConfigService::get('article', 'send_examine',0),
            'article_index_sort' => ConfigService::get('article', 'article_index_sort',1),
            'article_security'   => ConfigService::get('security', 'is_open', 0),
            'secret_key'   => ConfigService::get('security', 'qcloud', "")['secret_key'],
            'secret_id'   => ConfigService::get('security', 'qcloud',  "")['secret_id'],
            'region'   => ConfigService::get('security', 'qcloud',  "")['region'],
            'bucket'   => ConfigService::get('security', 'qcloud',  "")['bucket'],
            'disclaimer_status' => ConfigService::get('article', 'disclaimer_status',1),
            'disclaimer_value' => ConfigService::get('article', 'disclaimer_value',''),
            'send_require_circle' => ConfigService::get('article', 'send_require_circle',0),
            'max_word_len_ellipsis' => ConfigService::get('article', 'max_word_len_ellipsis',0),
            'min_word_len_ellipsis' => ConfigService::get('article', 'min_word_len_ellipsis',0),
            "send_limit_day"=>ConfigService::get('article', 'send_limit_day',10),
            "send_get_integral"=>ConfigService::get('article', 'send_get_integral',0),
            "send_get_experience"=>ConfigService::get('article', 'send_get_experience',0),
            'video_status'=>ConfigService::get('article', 'video_status',0),
            "send_comment_limit_day"=>ConfigService::get('article', 'send_comment_limit_day',0),
            "send_comment_get_integral"=>ConfigService::get('article', 'send_comment_get_integral',0),
            "is_update"=>ConfigService::get('article', 'is_update',0),
            "max_image"=>ConfigService::get('article', 'max_image',0),
            "send_get_experience_globle"=>ConfigService::get('article', 'send_get_experience_globle',0),
            "send_require_wechat"=>ConfigService::get('article', 'send_require_wechat',0),
            "enable_rich_text"=>ConfigService::get('article', 'enable_rich_text',0),
        ];
    }

    /**
     * 获取敏感词库
     */
    public static function getDangerWordConfig(): array
    {
        return [
            'words' => ConfigService::get('danger', 'words',''),
        ];
    }

    /**
     * 设置敏感词库
     */
    public static function setDangerWordConfig(array $params)
    {
        ConfigService::set('danger', 'words', $params['words'] ?? 1);
        return true;
    }
}