<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\settings\goods;


use app\common\logic\BaseLogic;
use app\common\service\ConfigService;
use app\common\service\FileService;

class GoodsSettingsLogic extends BaseLogic
{
    /**
     * @notes 设置商品配置
     * @param $params
     * @return bool
     */
    public function setConfig($params)
    {
        ConfigService::set('goods_set', 'image', $params['image'] ?? '');
        ConfigService::set('goods_set', 'is_show', $params['is_show'] ?? '');
        ConfigService::set('goods_set', 'show_price', $params['show_price'] ?? '');
        return true;
    }

    /**
     * @notes 查看商品配置
     * @return array
     */
    public function getConfig()
    {
        $image = ConfigService::get('goods_set', 'image', '');
        $image = empty($image) ? '' : FileService::getFileUrl($image);
        $config = [
            'image' => $image,
            'is_show' => ConfigService::get('goods_set', 'is_show', 1),
            'show_price' => ConfigService::get('goods_set', 'show_price', 1)
        ];
        return $config;
    }

}