<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\settings\delivery;


use app\common\logic\BaseLogic;
use app\common\service\ConfigService;

class LogisticsConfigLogic extends BaseLogic
{
    /**
     * @notes 查看物流配置
     * @return array
     */
    public function getLogisticsConfig()
    {
        $default = [
            'express_bird' => serialize([
                'set_meal' => 'free',
                'app_key' => '',
                'ebussiness_id' => '',
            ]),
            'express_hundred' => serialize([
                'interface_type' => 'enterprise',
                'app_key' => '',
                'customer' => ''
            ]),
            'express_aliyun' => serialize([
                'app_key' => '22app_key',
                'app_secret' => '22app_secret',
                'app_code' => '22app_code'
            ]),
            'express_type' => 'express_bird'
        ];
        $data['express_bird'] = unserialize(ConfigService::get('logistics_config', 'express_bird', $default['express_bird']));
        $data['express_hundred'] = unserialize(ConfigService::get('logistics_config', 'express_hundred', $default['express_hundred']));
        $data['express_aliyun'] = unserialize(ConfigService::get('logistics_config', 'express_hundred', $default['express_hundred']));
        $data['express_type'] = ConfigService::get('logistics_config', 'express_type', $default['express_type']);
        return $data;
    }

    /**
     * @notes 设置物流配置
     * @param $params
     * @return bool
     */
    public function setLogisticsConfig($params)
    {
        ConfigService::set('logistics_config', 'express_bird', serialize($params['express_bird']));
        ConfigService::set('logistics_config', 'express_hundred', serialize($params['express_hundred']));
        ConfigService::set('logistics_config', 'express_aliyun', serialize($params['express_aliyun']));
        ConfigService::set('logistics_config', 'express_type', $params['express_type']);

        return true;
    }
}