<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\order;


use app\common\enum\DeliveryEnum;
use app\common\enum\OrderEnum;
use app\common\enum\PayEnum;
use app\common\enum\YesNoEnum;
use app\common\logic\BaseLogic;
use app\common\model\Order;

class OrderBtnLogic extends BaseLogic
{
    /**
     * @notes 订单按钮状态
     * @param Order $order
     * @return array
     */
    public static function getOrderBtn(Order $order)
    {
        return [
            'detail_btn'          => self::getDetailBtn($order),
            'remark_btn'          => self::getRemarkBtn($order),
            'cancel_btn'          => self::getCancelBtn($order),
            'delete_btn'          => self::getDeleteBtn($order),
            'deliver_btn'         => self::getDeliverBtn($order),
            'confirm_btn'         => self::getConfirmBtn($order),
            'logistics_btn'       => self::getLogisticsBtn($order),
            'refund_btn'          => self::getRefundBtn($order),
            'refund_detail_btn'   => self::getRefundDetailBtn($order)
        ];
    }

    /**
     * @notes 商家端订单按钮状态
     * @param Order $order
     * @return array
     * @author lgp
     * @date 2023/2/20 17:37
     */
    public static function getBusinesseBtn(Order $order)
    {
        return [
            'editaddress_btn'       => self::getEitaddressBtn($order),
            'deliver_btn'           => self::getDeliverBtn($order),
            'delivery_btn'          => self::getDeliveryBtn($order),
            'cancel_btn'            => self::getCancelBtn($order),
            'confirm_btn'           => self::getConfirmBtn($order),
            'finish_btn'            => self::getFinishBtn($order),
            'delete_btn'            => self::getDeletedBtn($order),
            'content_btn'           => self::getContentBtn($order),
        ];
    }



    /**
     * @notes 详情按钮
     * @param $order
     */
    public static function getDetailBtn($order)
    {
        return OrderEnum::BTN_SHOW;
    }

    /**
     * @notes 商家备注按钮
     * @param $order
     */
    public static function getRemarkBtn($order)
    {
        return OrderEnum::BTN_SHOW;
    }

    /**
     * @notes 取消订单按钮
     * @param $order
     */
    public static function getCancelBtn($order)
    {
        if ($order['order_status'] == OrderEnum::STATUS_WAIT_PAY || $order['order_status'] == OrderEnum::STATUS_WAIT_DELIVERY) {
            return OrderEnum::BTN_SHOW;
        }
        return OrderEnum::BTN_HIDE;
    }

    /**
     * @notes 删除订单按钮
     * @param $order
     */
    public static function getDeleteBtn($order)
    {
        if ($order['order_status'] == OrderEnum::STATUS_CLOSE) {
            return OrderEnum::BTN_SHOW;
        }
        return OrderEnum::BTN_HIDE;
    }

    /**
     * @notes 发货按钮
     * @param $order
     */
    public static function getDeliverBtn($order)
    {
        $btn = OrderEnum::BTN_HIDE;
        if ($order['order_status'] == OrderEnum::STATUS_WAIT_DELIVERY ) {
            $btn = OrderEnum::BTN_SHOW;
        }
        return $btn;
    }


    /**
     * @notes 确认收货按钮
     * @param $order
     */
    public static function getConfirmBtn($order)
    {
        if ($order['order_status'] == OrderEnum::STATUS_WAIT_RECEIVE && $order['express_status'] == YesNoEnum::YES) {
            return OrderEnum::BTN_SHOW;
        }

        return OrderEnum::BTN_HIDE;
    }

    /**
     * @notes 物流按钮
     * @param $order
     */
    public static function getLogisticsBtn($order)
    {
        if ($order['order_status'] >= OrderEnum::STATUS_WAIT_RECEIVE && $order['pay_status'] == PayEnum::ISPAID && $order['express_status'] == DeliveryEnum::SHIPPED ) {
            return OrderEnum::BTN_SHOW;
        }
        return OrderEnum::BTN_HIDE;
    }

    /**
     * @notes 手动退款按钮
     * @param $order
     */
    public static function getRefundBtn($order)
    {
        return OrderEnum::BTN_HIDE;
    }

    /**
     * @notes 退款明细按钮
     *
     * @param $order
     */
    public static function getRefundDetailBtn($order)
    {
        return OrderEnum::BTN_HIDE;
    }

    /**
     * @notes 修改地址按钮
     * @param $order
     */
    public static function getEitaddressBtn($order)
    {
        $btn = OrderEnum::BTN_HIDE;
        if(DeliveryEnum::EXPRESS_DELIVERY == $order['delivery_type'] && (OrderEnum::STATUS_WAIT_PAY == $order['order_status'] || OrderEnum::STATUS_WAIT_DELIVERY == $order['order_status'])) {
            $btn = OrderEnum::BTN_SHOW;
        }
        return $btn;
    }

    /**
     * @notes 物流按钮
     * @param $order
     * @return int
     */
    public static function getDeliveryBtn($order)
    {
        $btn = OrderEnum::BTN_HIDE;
        if ($order['order_status'] >= OrderEnum::STATUS_WAIT_RECEIVE
            && $order['pay_status'] == PayEnum::ISPAID
            && $order['express_status'] == YesNoEnum::YES
        ) {
            $btn = OrderEnum::BTN_SHOW;
        }
        return $btn;
    }

    /**
     * @notes 完成按钮
     * @param $order
     * @return int
     */
    public static function getFinishBtn($order)
    {
        $btn = OrderEnum::BTN_HIDE;
        if ($order['order_status'] == OrderEnum::STATUS_FINISH) {
            $btn = OrderEnum::BTN_SHOW;
        }
        return $btn;
    }

    /**
     * @notes 删除订单按钮
     * @param $order
     */
    public static function getDeletedBtn($order)
    {
        $btn = OrderEnum::BTN_HIDE;
        //订单已关闭
        if ($order['order_status'] == OrderEnum::STATUS_CLOSE) {
            $btn = OrderEnum::BTN_SHOW;
        }
        return $btn;
    }

    /**
     * @notes 查看内容按钮
     * @param $order
     * @date 2022/4/20 17:23
     */
    public static function getContentBtn($order){

        $btn = OrderEnum::BTN_HIDE;

        return $btn;
    }

}