<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\goods;


use app\common\enum\DefaultEnum;
use app\common\enum\YesNoEnum;
use app\common\model\GoodsCategory;

class GoodsCategoryLogic
{
    /**
     * @notes 添加商品分类
     * @param $params
     * @return bool
     */
    public function add($params)
    {
        $goods_category = new GoodsCategory;
        $goods_category->name = $params['name'];
        $goods_category->pid = $params['pid'] ?? 0;
        $goods_category->level = isset($params['pid']) ? (GoodsCategory::where('id',$params['pid'])->value('level') + 1) : 1;
        $goods_category->image = $params['image'] ?? '';
        $goods_category->sort = (isset($params['sort']) && !empty($params['sort'])) ? $params['sort'] : DefaultEnum::SORT;
        $goods_category->is_show = $params['is_show'] ?? YesNoEnum::YES;
        $goods_category->is_recommend = $params['is_recommend'] ?? YesNoEnum::YES;
        return $goods_category->save();
    }

    /**
     * @notes 修改商品分类状态
     * @param $params
     * @return bool
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function status($params)
    {
        $goods_category = GoodsCategory::find($params['id']);
        $goods_category->is_show = $params['is_show'];
        return $goods_category->save();
    }

    /**
     * @notes 删除商品分类
     * @param $params
     * @return bool
     */
    public function del($params)
    {
        return GoodsCategory::destroy($params['id']);
    }

    /**
     * @notes 编辑商品分类
     * @param $params
     * @return bool
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function edit($params)
    {
        $pid = $params['pid'] ?? 0;
        $level = ($pid > 0) ? (GoodsCategory::where('id',$pid)->value('level') + 1) : 1;

        //更新分类信息
        $goods_category = GoodsCategory::find($params['id']);
        $goods_category->name = $params['name'];
        $goods_category->pid = $pid;
        $goods_category->level = $level;
        $goods_category->image = $params['image'];
        $goods_category->sort = $params['sort'];
        $goods_category->is_show = $params['is_show'];
        $goods_category->is_recommend = $params['is_recommend'];
        $goods_category->save();

        //更新下级分类信息
        $goods_category_son = GoodsCategory::where('pid',$params['id'])->select()->toArray();
        if (empty($goods_category_son)) {
            return true;
        }
        foreach ($goods_category_son as $val) {
            $data[] = ['id'=>$val['id'],'level'=>$level+1];
        }
        $goods_category->saveAll($data);

        return true;
    }

    /**
     * @notes 查看商品分类详情
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function detail($params)
    {
        return GoodsCategory::find($params['id'])->toArray();
    }

    /**
     * @notes 获取完整的分类
     * @param array $ids 获取某个某个分类
     * @return array
     */
    public static function getCategoryNameLists(array $ids = []):array
    {
        $where = [];
        if($ids){
            $where[] = ['C.id'=>$ids];
        }
        $list = GoodsCategory::alias('C')
            ->leftJoin('goods_category B','C.pid = B.id')
            ->leftJoin('goods_category A','B.pid = A.id')
            ->where($where)
            ->column('A.id as A_id,A.name as A_name,B.id as B_id,B.name as B_name,C.id as C_id,C.name as C_name,
CONCAT_WS(\'/\',A.name,B.name,C.name) as category_name','C.id');

        return $list;
    }

    /**
     * @notes 获取完整分类名称
     * @param $id
     * @param bool $flag
     * @return mixed|string
     */
    public static function getCompleteName($id, $flag = true) {
        static $completeName = '';
        if($flag) {
            $completeName = GoodsCategory::where('id', $id)->value('name');
        }
        $pid = GoodsCategory::where('id', $id)->value('pid');
        if($pid) {
            $pidName = GoodsCategory::where('id', $pid)->value('name');
            $completeName = $pidName . '/' . $completeName;
            self::getCompleteName($pid, false);
        }
        return $completeName;
    }
}