<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\logic\auth;
use think\facade\Cache;
use think\facade\Config;

/**
 * 权限功能类
 * Class AuthLogic
 * @package app\adminapi\logic\auth
 */
class AuthLogic
{
    /**
     * @notes 获取菜单
     * @return array
     */
    public static function getMenu():array
    {
        $menu = Config::get('menu');
        return $menu;
    }

    /**
     * @notes 获取权限
     * @param array $authKeys array-返回指定权限
     * @return array
     */
    public static function getAuth(array $authKeys = []):array
    {
        $authConfigList = Config::get('auth');
        //获取指定权限
        if(!empty($authKeys)){
            $authList = [];
            foreach ($authKeys as $keys){
                $keyList = explode('/',$keys);
                $authConfig = $authConfigList[$keyList[0]] ?? [];
                if(empty($authConfig)){
                    continue;
                }
                $keyList = explode('.',$keyList[1]);

                $buttonAuth = $authConfig[$keyList[0]][$keyList[1]]['button_auth'] ?? [];
                $actionAuth = $authConfig[$keyList[0]][$keyList[1]]['action_auth'] ?? [];

                $authList = [
                    'button_auth'   => array_merge($authList['button_auth'] ?? [],$buttonAuth),
                    'action_auth'   => array_merge($authList['action_auth'] ?? [],$actionAuth),
                ];
            }
            return $authList;
        }
        return $authConfigList;

    }
}