<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\lists\group;


use app\adminapi\lists\BaseAdminDataLists;
use app\common\lists\ListsExcelInterface;
use app\common\model\GroupCategory;

class GroupCategoryLists extends BaseAdminDataLists implements ListsExcelInterface
{
    /**
     * @notes 设置导出字段
     * @return string[]
     */
    public function setExcelFields(): array
    {
        return [
            // '数据库字段名(支持别名) => 'Excel表字段名'
            'name' => '分类名称',
            'level' => '分类等级',
            'image' => '分类图标',
            'is_show_desc' => '状态',
            'sort' => '排序',
            'create_time' => '创建时间',
        ];
    }

    /**
     * @notes 设置默认表名
     * @return string
     */
    public function setFileName(): string
    {
        return '商品分类';
    }

    /**
     * @notes 查看商品分类列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $lists = GroupCategory::field('id,pid,name,level,image,is_show,is_recommend,sort,create_time')
            ->order(['sort'=>'asc','id'=>'desc'])
            ->append(['is_show_desc'])
            ->select()
            ->toArray();

        $lists = linear_to_tree($lists,'sons');

        //分页
//        $page_no = $this->pageNo * $this->pageSize - $this->pageSize;
//        $lists = array_slice($lists, $page_no, $this->pageSize);

        return $lists;
    }

    /**
     * @notes 查看商品分类总数
     * @return int
     */
    public function count(): int
    {
        return GroupCategory::count();
    }
}