<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\user;
use app\adminapi\{
    // validate\user\UserLevelValidate,
    logic\user\VipLevelLogic,
    controller\BaseAdminController,
};

/**
 * 会员等级控制器
 * Class UserLevelController
 * @package app\adminapi\controller\user
 */
class VipLevel extends BaseAdminController
{
    /**
     * @notes 用户等级列表
     * @return \think\response\Json
     */
    public function lists()
    {
        return $this->dataLists();
    }


    /**
     * @notes 添加会员等级
     * @return \think\response\Json
     */
    public function add()
    {
        // $params = (new UserLevelValidate())->post()->goCheck('add');
        $params = $this->request->post();
        (new VipLevelLogic)->add($params);
        return $this->success('添加等级成功',[],1,1);
    }


    /**
     * @notes 获取会员等级
     * @return \think\response\Json
     */
    public function detail()
    {
        $id = $this->request->get('id');
        $detail = (new VipLevelLogic())->detail($id);
        return $this->success('',$detail);
    }

    /**
     * @notes 修改会员等级
     * @return \think\response\Json
     */
    public function edit()
    {
        // $params = (new UserLevelValidate())->post()->goCheck();
        $params = $this->request->post();
        (new VipLevelLogic)->edit($params);
        return $this->success('修改等级成功',[],1,1);
    }

    /**
     * @notes 删除会员等级
     * @return \think\response\Json
     */
    public function del(){
        // $params = (new UserLevelValidate())->post()->goCheck('del');
        $params = $this->request->post();
        (new VipLevelLogic())->del($params['id']);
        return $this->success('删除成功');
    }


}