<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings\webapp;

use app\adminapi\controller\BaseAdminController;

use app\common\service\ConfigService;

/**
 * APP设置控制器
 * Class WebAppSettingController
 * @package app\adminapi\controller\settings\app
 */
class WebAppSetting extends BaseAdminController
{

    /**
     * @notes 获取App设置
     * @return \think\response\Json
    */
    public function getConfig()
    {
        return show(1,'',[
            'app_id'=> ConfigService::get('webapp', 'app_id', ''),
            'app_secret'=>ConfigService::get('webapp', 'app_secret', ''),
        ]);
    }

    /**
     * @notes App设置
     * @return \think\response\Json
     */
    public function setConfig()
    {
        $params = $this->request->post();
        ConfigService::set('webapp', 'app_id', $params['app_id'] ?? '');
        ConfigService::set('webapp', 'app_secret', $params['app_secret'] ?? '');

        return $this->success('设置成功', [], 1, 1);

    }


    
}