<?php

namespace app\adminapi\controller\settings\user;

use app\adminapi\controller\BaseAdminController;
use app\common\service\ConfigService;

class UserLabel extends BaseAdminController
{
    public function getConfig()
    {
        return $this->data([
            'max_label_num' => ConfigService::get('user', 'max_label_num', 7),
        ]);
    }

    public function setConfig()
    {
        $params = $this->request->post();
        if (isset($params['max_label_num'])) {
            ConfigService::set('user', 'max_label_num', $params['max_label_num']);
        }
        return $this->success('设置成功');
    }
}