<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings\shop;

use app\adminapi\controller\BaseAdminController;
use app\adminapi\logic\settings\shop\ShopSettingLogic;
use app\adminapi\validate\settings\shop\ShopSettingsValidate;

/**
 * 店铺设置控制器
 * Class ShopSettingController
 * @package app\adminapi\controller\settings\shop
 */
class ShopSetting extends BaseAdminController
{
    /**
     * @notes 获取店铺信息
     * @return \think\response\Json
     */
    public function getShopInfo()
    {
        $result = ShopSettingLogic::getShopInfo();
        return $this->data($result);
    }

    /**
     * @notes 设置店铺信息
     * @return \think\response\Json
     */
    public function setShopInfo()
    {
        $params = (new ShopSettingsValidate())->post()->goCheck('setShopInfo');
        ShopSettingLogic::setShopInfo($params);
        return $this->success('设置成功');
    }

    /**
     * @notes 获取备案信息
     * @return \think\response\Json
     */
    public function getRecordInfo()
    {
        $result = ShopSettingLogic::getRecordInfo();
        return $this->data($result);
    }

    /**
     * @notes 设置备案信息
     * @return \think\response\Json
     */
    public function setRecordInfo()
    {
        $params = $this->request->post();
        ShopSettingLogic::setRecordInfo($params);
        return $this->success('设置成功');
    }

    /**
     * @notes 获取分享设置
     * @return \think\response\Json
     */
    public function getShareSetting()
    {
        $result = ShopSettingLogic::getShareSetting();
        return $this->data($result);
    }

    /**
     * @notes 分享设置
     * @return \think\response\Json
     */
    public function setShareSetting()
    {
        $params = (new ShopSettingsValidate())->post()->goCheck('setShareSetting');
        ShopSettingLogic::setShareSetting($params);
        return $this->success('设置成功');
    }

    /**
     * @notes 获取政策协议
     * @return \think\response\Json
     */
    public function getPolicyAgreement()
    {
        $result = ShopSettingLogic::getPolicyAgreement();
        return $this->data($result);
    }

    /**
     * @notes 设置政策协议
     * @return \think\response\Json
     */
    public function setPolicyAgreement()
    {
        $params = $this->request->post();
        ShopSettingLogic::setPolicyAgreement($params);
        return $this->success('设置成功');
    }

    /**
     * @notes 设置地图秘钥
     * @return \think\response\Json
     * @author lgp
     * @date 2022/3/10 5:12 下午
     */
    public function setMapKey()
    {
        $params = $this->request->post();
        ShopSettingLogic::setMapKey($params);
        return $this->success('设置成功');
    }

    /**
     * @notes 获取地图秘钥
     * @return \think\response\Json
     * @author lgp
     * @date 2022/3/10 5:12 下午
     */
    public function getMapKey()
    {
        $result = ShopSettingLogic::getMapKey();
        return $this->data($result);
    }
}