<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings\shop;

use app\adminapi\controller\BaseAdminController;
use app\adminapi\logic\settings\shop\ShopSettingLogic;
use app\adminapi\validate\settings\shop\ShopSettingsValidate;
use function Swoole\Coroutine\Http\post;

/**
 * 店铺设置控制器
 * Class ShopSettingController
 * @package app\adminapi\controller\settings\shop
 */
class ChatSetting extends BaseAdminController
{
    /**
     * @return \think\response\Json
     */
    public function getChatInfo()
    {
        $result = [  
            'private_status'  => \app\common\service\ConfigService::get('chat', 'private_status',0),
            'group_status'  => \app\common\service\ConfigService::get('chat', 'group_status',0),
            'circle_status'  => \app\common\service\ConfigService::get('chat', 'circle_status',0),
            'group_profit_pct'  => \app\common\service\ConfigService::get('chat', 'group_profit_pct',0),
        ];
        return $this->data($result);
    }

    /**
     * @return \think\response\Json
     */
    public function setChatInfo()
    {
        $params = $this->request->post();
        \app\common\service\ConfigService::set('chat','private_status', $params['private_status']);
        \app\common\service\ConfigService::set('chat','group_status', $params['group_status']);
        \app\common\service\ConfigService::set('chat','circle_status', $params['circle_status']);
        \app\common\service\ConfigService::set('chat','group_profit_pct', $params['group_profit_pct']);
        return $this->success('设置成功');
    }

}