<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings\pay;


use app\adminapi\controller\BaseAdminController;
use app\adminapi\lists\settings\delivery\PayConfigLists;
use app\adminapi\logic\settings\pay\PayConfigLogic;
use app\adminapi\validate\settings\pay\PayConfigValidate;

class PayConfig extends BaseAdminController
{
    /**
     * @notes 设置支付配置
     * @return \think\response\Json
     */
    public function setConfig()
    {
        $params = (new PayConfigValidate())->post()->goCheck();
        (new PayConfigLogic())->setConfig($params);
        return $this->success('设置成功',[],1,1);
    }

    /**
     * @notes 查看支付配置
     * @return \think\response\Json
     */
    public function getConfig()
    {
        $id = (new PayConfigValidate())->goCheck('get');
        $result = (new PayConfigLogic())->getConfig($id);
        return $this->success('获取成功',$result);
    }

    /**
     * @notes 查看支付配置列表
     * @return \think\response\Json
     */
    public function lists()
    {
        return $this->dataLists(new PayConfigLists());
    }
}