<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings\h5;

use app\adminapi\controller\BaseAdminController;
use app\adminapi\logic\settings\h5\HFiveSettingLogic;
use app\adminapi\validate\settings\h5\HFiveSettingValidate;

/**
 * H5设置控制器
 * Class HFiveSettingController
 * @package app\adminapi\controller\settings\h5
 */
class HFiveSetting extends BaseAdminController
{
    /**
     * @notes 获取H5设置
     * @return \think\response\Json
     */
    public function getConfig()
    {
        $result = HFiveSettingLogic::getConfig();
        return $this->data($result);
    }

    /**
     * @notes H5设置
     * @return \think\response\Json
     */
    public function setConfig()
    {
        $params = (new HFiveSettingValidate())->post()->goCheck();
        HFiveSettingLogic::setConfig($params);
        return $this->success('设置成功', [], 1, 1);
    }
}