<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings;

use app\adminapi\controller\BaseAdminController;

use app\common\service\ConfigService;

/**
 * APP设置控制器
 * Class WebAppSettingController
 * @package app\adminapi\controller\settings\app
 */
class EmailSetting extends BaseAdminController
{

    /**
     * @notes 获取App设置
     * @return \think\response\Json
    */
    public function getConfig()
    {
        return show(1,'',[
            'host'=> ConfigService::get('email', 'host', 'smtp.qq.com'),
            'port'=> ConfigService::get('email', 'port', '587'),
            'user'=> ConfigService::get('email', 'user', ''),
            'pass'=> ConfigService::get('email', 'pass', ''),
            'from_name'=> ConfigService::get('email', 'from_name', ''),
        ]);
    }

    /**
     * @notes App设置
     * @return \think\response\Json
     */
    public function setConfig()
    {
        $params = $this->request->post();
        
        ConfigService::set('email', 'host', $params['host'] ?? '');
        ConfigService::set('email', 'port', $params['port'] ?? '');
        ConfigService::set('email', 'user', $params['user'] ?? '');
        ConfigService::set('email', 'pass', $params['pass'] ?? '');
        ConfigService::set('email', 'from_name', $params['from_name'] ?? '');
        
        return $this->success('设置成功', [], 1, 1);
    }

}