<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\collect;
use app\common\model\Config;
use think\facade\Db;
use app\adminapi\controller\BaseAdminController;

/**
 * dz圈子绑定关系
 */
class DzCircleBind extends BaseAdminController
{

    /**
     * 添加绑定
     */
    public function add()
    {
        $params = $this->request->post();
        // 有的话先删除
        foreach($params['list'] as $v){
            // 有的话先删除
            $res=\app\common\model\DzCircleBind::where('sns_circle_id',$v['sns_circle_id'])->find();
            if($res){
                $res->delete();
            }
        }

        \app\common\model\DzCircleBind::insertAll($params['list']);
        return show(config('status.success'),'添加成功');
    }

    /**
     * 绑定列表
     */
    public function list()
    {
        $params =$this->request->get();
        $list = \app\common\model\DzCircleBind::whereIn('dz_circle_id',$params['dz_circle_ids'])
        ->select();
        return show(config('status.success'),'套餐列表',$list);
    }


    // 解绑
    public function del($id)
    {
        $list = \app\common\model\DzCircleBind::where('id',$id)->delete();
        return show(config('status.success'),'删除成功');
    }



}
