<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\collect;

use app\adminapi\controller\BaseAdminController;


/**
 * 圈子数据采集
 * Class UserController
 * @package app\adminapi\controller\user
 */
class CircleCollect extends BaseAdminController
{

    // DZ用户数据采集
    public function insertCircleDZ()
    {
        $list = $this->request->post('list');
        $page = $this->request->post('page');

        $saveData=[];

        foreach($list as $v){
            $saveData[]=[
                "name"=>$v['name'],//圈子名称
                "dz_id"=>intval($v['fid']),
            ];
        }

        try{

            $res = \think\facade\Db::name('circle')
            ->extra('IGNORE')
            ->insertAll($saveData);

            // 记录当前页数 用于下次断点采集
            \app\common\service\ConfigService::set('circle_collect','dz_page',$page);

            return \show(1,'导入成功');
        }catch(\Exception $e){
            return \show(0,'导入失败'.$e->getMessage());
        }

        
    }

    // 删除所有dz采集的用户数据
    public function delAllDZCircle()
    {
        \app\common\model\Circle::whereNotNull("dz_id")->select()->delete();
        return \show(1,'删除成功');
    }

    // 查询上一次采集到第几页
    public function dzPageRecord()
    {
        $page=\app\common\service\ConfigService::get('circle_collect','dz_page',0);
        return \show(1,['page'=>$page]);
    }

    // 清楚断点采集记录
    public function dzPageRecordDel()
    {
        $page=\app\common\service\ConfigService::set('circle_collect','dz_page',0);
        return \show(1,['page'=>$page]);
    }

}