<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */
namespace app\adminapi\controller\ad;

use app\adminapi\controller\BaseAdminController;
use app\adminapi\lists\ad\AdLists;
use app\adminapi\logic\ad\AdLogic;
use app\adminapi\validate\ad\AdValidate;
use app\common\service\JsonService;

/**
 * 广告位
 */
class Ad extends BaseAdminController
{
    /**
     * @notes 添加广告
     */
    public function add()
    {
        $params = (new AdValidate())->post()->goCheck('add');
        $result = AdLogic::add($params);
        if ($result) {
            return JsonService::success('添加成功');
        }
        return JsonService::fail(AdLogic::getError());
    }



    /**
     * @notes 编辑广告
     */
    public function edit()
    {
        $params = (new AdValidate())->post()->goCheck('edit');
        $result = AdLogic::edit($params);
        if ($result) {
            return JsonService::success('编辑成功');
        }
        return JsonService::fail(AdLogic::getError());
    }


    /**
     * @notes 删除广告
     */
    public function delete()
    {
        $params = (new AdValidate())->post()->goCheck('del');
        $result = AdLogic::delete($params);
        if ($result) {
            return JsonService::success('删除成功');
        }
        return JsonService::fail(AdLogic::getError());
    }

     /**
     * @notes 详情
     */
    public function detail()
    {
        $params = $this->request->get();
        $detail = AdLogic::detail($params);
        
        return $this->data($detail);
        
        
    }


    /**
     * @notes 广告列表
     */
    public function lists()
    {
        return JsonService::dataLists(new AdLists());
    }


    /**
     * @notes 其他列表
     */
    public function otherList(){
        
        $params = $this->request->get();
        $list = (new AdLogic())->otherList($params);
        return $this->success('',$list);
    }

}
